"use strict";
'use client';

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;
var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMPTY_RENDER_CONTEXT = void 0;
exports.useGridVirtualization = useGridVirtualization;
exports.virtualizationStateInitializer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _useGridApiMethod = require("../../utils/useGridApiMethod");
const EMPTY_RENDER_CONTEXT = exports.EMPTY_RENDER_CONTEXT = {
  firstRowIndex: 0,
  lastRowIndex: 0,
  firstColumnIndex: 0,
  lastColumnIndex: 0
};
const virtualizationStateInitializer = (state, props) => {
  const {
    disableVirtualization,
    autoHeight
  } = props;
  const virtualization = {
    enabled: !disableVirtualization,
    enabledForColumns: !disableVirtualization,
    enabledForRows: !disableVirtualization && !autoHeight,
    renderContext: EMPTY_RENDER_CONTEXT
  };
  return (0, _extends2.default)({}, state, {
    virtualization
  });
};
exports.virtualizationStateInitializer = virtualizationStateInitializer;
function useGridVirtualization(apiRef, props) {
  /*
   * API METHODS
   */

  const setVirtualization = enabled => {
    apiRef.current.setState(state => (0, _extends2.default)({}, state, {
      virtualization: (0, _extends2.default)({}, state.virtualization, {
        enabled,
        enabledForColumns: enabled,
        enabledForRows: enabled && !props.autoHeight
      })
    }));
  };
  const setColumnVirtualization = enabled => {
    apiRef.current.setState(state => (0, _extends2.default)({}, state, {
      virtualization: (0, _extends2.default)({}, state.virtualization, {
        enabledForColumns: enabled
      })
    }));
  };
  const api = {
    unstable_setVirtualization: setVirtualization,
    unstable_setColumnVirtualization: setColumnVirtualization
  };
  (0, _useGridApiMethod.useGridApiMethod)(apiRef, api, 'public');

  /*
   * EFFECTS
   */

  /* eslint-disable react-hooks/exhaustive-deps */
  React.useEffect(() => {
    setVirtualization(!props.disableVirtualization);
  }, [props.disableVirtualization, props.autoHeight]);
  /* eslint-enable react-hooks/exhaustive-deps */
}